<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('entries', function (Blueprint $table) {
            $table->id();
            $table->string('title')->unique();
            $table->text('description')->nullable();
            $table->integer('pages')->comment('Number of Pages')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->date('publish_date')->nullable();
            $table->text('notes')->nullable();
            $table->string('cover')->nullable();
            $table->unsignedBigInteger('publisher_id')->index()->nullable();
            $table->foreign('publisher_id')->references('id')->on((new \App\Models\Publisher())->getTable());
            $table->unsignedBigInteger('type_id')->index();
            $table->foreign('type_id')->references('id')->on((new \App\Models\Type)->getTable());
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('entries');
    }
};
